use_script("belt.lua");

local beltColorMap = {};
beltColorMap[color_from_rgb(0xFF, 0x00, 0x00)] = color_from_rgb(68, 68, 68);
beltColorMap[color_from_rgb(0x00, 0xFF, 0x00)] = color_from_rgb(79, 79, 79);
beltColorMap[color_from_rgb(0x00, 0x00, 0xFF)] = color_from_rgb(179, 127, 0);
beltColorMap[color_from_rgb(0xFF, 0x00, 0xFF)] = color_from_rgb(217, 217, 0);

local activeLightMap = {};
activeLightMap[color_from_rgb(0xFF, 0x00, 0x00)] = 0;
activeLightMap[color_from_rgb(0x00, 0xFF, 0x00)] = 0;
activeLightMap[color_from_rgb(0x00, 0x00, 0xFF)] = color_from_rgba(0xFF, 0xFF, 0xFF, 0);
activeLightMap[color_from_rgb(0xFF, 0x00, 0xFF)] = color_from_rgba(0xFF, 0xFF, 0xFF, 0);

function modify_frame(active, orient, overallFrameNum, colormap, lightspecmap)
    local motor = rotate_sprite(vsp_from_assets("templates/belts/motor.vsp"), orient);
    vsp_merge(colormap, motor);
end

function modify_mask(active, orient, mask)
    local motorMask = rotate_sprite(vsp_from_assets("templates/belts/motorMask.vsp"), orient);
    vsp_merge(mask, motorMask);
end

export_belt(beltColorMap, activeLightMap, modify_mask, modify_frame);