local bias = color_from_rgb(0x00, 0x01, 0x01);
local water_color = color_from_rgba(12, 250, 250, 255);
local water_bias = color_from_rgb(0x03, 0x03, 0x22);

local fertility_colors = {
    color_from_rgb(0xBF, 0xBE, 0x5F),
    color_from_rgb(0x3F, 0x2B, 0x27),
    color_from_rgb(0x15, 0x1b, 0x14),
    color_from_rgb(0x00, 0x25, 0x00),
};

local axis_names = { "xorient", "yorient" };

for axis = 0, 1 do
    for water = 0, 3 do
        for fertility = 0, 3 do
            local state_name = string.format("%s/water%d/fertility%d", axis_names[axis + 1], water, fertility);

            local colormap = vsp_new(8, 8, 8);
            vsp_fill(colormap, fertility_colors[fertility + 1]);
            
            local biasmap = vsp_new(8, 8, 8);
            vsp_fill(biasmap, bias);

            for u = 0, 7 do
                for v = 0, 3 do
                    local voxel_pos = {};
                    voxel_pos[axis + 1] = u;
                    voxel_pos[(axis ~ 1) + 1] = 2 * v;

                    vsp_set_voxel(colormap, voxel_pos[1], voxel_pos[2], 7, TRANSPARENT);
                    vsp_set_voxel(biasmap, voxel_pos[1], voxel_pos[2], 7, BLACK);

                    if water > 0 then
                        local water_start = 3 - water;
                        local water_end = 4 + water;

                        if u >= water_start and u <= water_end then
                            vsp_set_voxel(colormap, voxel_pos[1], voxel_pos[2], 7, water_color);
                            vsp_set_voxel(biasmap, voxel_pos[1], voxel_pos[2], 7, water_bias);
                        end
                    end
                end
            end

            export_frame(state_name, {
                colormap = colormap,
                biasmap = biasmap,
            });
        end
    end
end
