use_script("utils.lua");
use_script("rotate.lua");

local templ = vsp_from_assets("templates/fluidDispenser.vsp");

for side = 0, 5 do
    local stateName = "output" .. get_side_name(side);
    local colormap = rotate_sprite(templ, side);

    local biasmap = vsp_clone(colormap);
    local bias_values = {};
    bias_values[color_from_rgb(0xBF, 0xBF, 0xBF)] = color_from_rgb(0x00, 0x00, 0x05);

    vsp_color_remap_with_default(biasmap, bias_values, 0);

    local lightspecmap = vsp_new(8, 8, 8);
    vsp_fill(lightspecmap, color_from_rgba(0x00, 0x00, 0x00, 0xFF));

    export_frame(stateName, {
        colormap = colormap,
        biasmap = biasmap,
        lightspecmap = lightspecmap,
    })
end