use_script("utils.lua");
use_script("rotate.lua");

local templ = vsp_from_assets("templates/pump.vsp");
local electricInputTempl = vsp_from_assets("templates/connectors/electricInput.vsp");

for side = 0, 5 do
    local stateName = "input" .. get_side_name(side);
    local colormap = rotate_sprite(templ, side);

    local electricInputSide = 4;
    if side > 3 then
        electricInputSide = 3;
    end

    vsp_merge(colormap, rotate_sprite(electricInputTempl, electricInputSide));

    local biasmap = vsp_clone(colormap);
    local bias_values = {};
    bias_values[color_from_rgb(0xBF, 0xBF, 0xBF)] = color_from_rgb(0x00, 0x00, 0x05);
    vsp_color_remap_with_default(biasmap, bias_values, 0);

    local lightspecmap = vsp_clone(colormap);
    local lightspec_values = {};
    lightspec_values[color_from_rgb(0x00, 0x00, 0xFF)] = color_from_rgba(0x00, 0x00, 0xFF, 0x00);
    vsp_color_remap_with_default(lightspecmap, lightspec_values, 0);

    export_frame(stateName, {
        colormap = colormap,
        biasmap = biasmap,
        lightspecmap = lightspecmap,
    })
end