use_script("utils.lua");

-- Generates and exports bricks sprites.
-- `material_color` is the color to use for the material voxels;
-- `material_bias` is its bias value.
-- `mortar_color` is the color to use for the mortar voxels; optional.
-- `mortar_bias` is the bias value for the mortar.
function export_bricks(material_color, material_bias, mortar_color, mortar_bias)
    local MATERIAL_KEY = color_from_rgb(0, 255, 0);
    local MORTAR_KEY = color_from_rgb(0, 0, 255);
    
    local templ = vsp_from_assets("templates/bricks.vsp");
    
    for i = 0, 15 do
        local localTempl = vsp_clone(templ);
        vsp_pluck_sides(localTempl, i | (1 << 4) | (1 << 5), MORTAR_KEY);

        local color_values = {};
        color_values[MATERIAL_KEY] = material_color;
        color_values[MORTAR_KEY] = mortar_color or color_from_rgb(0x44, 0x44, 0x44);
        
        local bias_values = {};
        bias_values[MATERIAL_KEY] = material_bias;
        bias_values[MORTAR_KEY] = mortar_bias or color_from_rgb(0, 0, 8);
        
        local colormap = vsp_clone(localTempl);
        vsp_color_remap(colormap, color_values);
        
        local biasmap = localTempl;
        vsp_color_remap(biasmap, bias_values);
        
        export_frame(tobin(i, 4), {
            colormap = colormap,
            biasmap = biasmap,
        });
    end
end