use_script("utils.lua");

function remap_for_open(x, y, z)
    return y, x, z
end

function remap_for_y_axis(x, y, z)
    return 7 - y, x, z
end

function remap_for_opposite(x, y, z)
    return 7 - x, 7 - y, z
end

function export_door(outer_frame_color, inner_frame_color, handle_color, bias)
    local OUTER_FRAME_KEY = color_from_rgb(255, 0, 0);
    local INNER_FRAME_KEY = color_from_rgb(0, 255, 0);
    local HANDLE_KEY = color_from_rgb(0, 0, 255);

    local templ_map = {}
    templ_map[OUTER_FRAME_KEY] = outer_frame_color
    templ_map[INNER_FRAME_KEY] = inner_frame_color
    templ_map[HANDLE_KEY] = handle_color

    local templ_closed = vsp_from_assets("templates/door.vsp");
    vsp_color_remap(templ_closed, templ_map)

    local templ_open = remap_voxel_positions(templ_closed, remap_for_open);

    local biasmap = vsp_new(8, 8, 8);
    vsp_fill(biasmap, bias);
    
    for side = 0, 3 do
        local closed = templ_closed;
        local open = templ_open;
    
        if (side & 2) ~= 0 then
            closed = remap_voxel_positions(templ_closed, remap_for_y_axis);
            open = remap_voxel_positions(templ_open, remap_for_y_axis);
        end
    
        if (side & 1) ~= 0 then
            closed = remap_voxel_positions(closed, remap_for_opposite);
            open = remap_voxel_positions(open, remap_for_opposite);
        end
    
        for segment_index = 0, 2 do
            local segment_closed = vsp_from_cropped(closed, 0, 0, 8 * segment_index, 8, 8, 8);
            local segment_open = vsp_from_cropped(open, 0, 0, 8 * segment_index, 8, 8, 8);
        
            export_frame("closed" .. get_side_name(side) .. tostring(segment_index), {
                colormap = segment_closed,
                biasmap = biasmap,
            });
    
            export_frame("open" .. get_side_name(side) .. tostring(segment_index), {
                colormap = segment_open,
                biasmap = biasmap,
            });
        end
    end
end