use_script("utils.lua");

-- Rotate a sprite so that the west side becomes the specified side.
function rotate_sprite(vsp, side)
    function remap_func(x, y, z)
        if (side & 1) ~= 0 then
            x = 7 - x;
        end

        if (side >> 1) == 1 then
            local temp = x;
            x = y;
            y = temp;
        end

        if (side >> 1) == 2 then
            local temp = x;
            x = z;
            z = temp;
        end

        return x, y, z;
    end

    return remap_voxel_positions(vsp, remap_func);
end