use_script("palette.lua");

local color_name = BLOCK_PURE_NAME:sub(1, -5);
local color_set = palette[color_name]

if color_set == nil then
    return
end

local colormap = vsp_new(8, 8, 8);
vsp_fill(colormap, color_set.flat);

local biasmap = vsp_new(8, 8, 8);
vsp_fill(biasmap, color_from_rgb(1, 2, 6));

export_frame("default", {
    colormap = colormap,
    biasmap = biasmap,
});