use_script("palette.lua");

local color_name = BLOCK_PURE_NAME:sub(1, -7);
local color_set = palette[color_name];

local SHINY_KEY = color_from_rgb(255, 0, 0);
local FLAT_KEY = color_from_rgb(0, 255, 0);
local DAMP_KEY = color_from_rgb(0, 0, 255);

local color_values = {};
color_values[SHINY_KEY] = color_set.shiny;
color_values[FLAT_KEY] = color_set.flat;
color_values[DAMP_KEY] = color_set.damp;

local colormap = vsp_from_assets("templates/planks.vsp");
vsp_color_remap(colormap, color_values);

local biasmap = vsp_new(8, 8, 8);
vsp_fill(biasmap, color_from_rgb(0, 2, 5));

local collision_mask = vsp_new(8, 8, 8);
vsp_fill(collision_mask, WHITE);

export_frame("default", {
    colormap = colormap,
    biasmap = biasmap,
});

set_collision_mask("default", collision_mask);