use_script("palette.lua");

local color_name = BLOCK_PURE_NAME:sub(1, -6);
local color_set = palette[color_name]
local alpha = 0x7F;

if color_set == nil then
    return
end

local colormap = vsp_new(8, 8, 8);
vsp_fill(colormap, (color_set.saturated & ~0xFF000000) | (alpha << 24));

local refractmap = vsp_new(8, 8, 8);
vsp_fill(refractmap, color_from_rgb(0, 39, 0));

export_frame("default", {
    colormap = colormap,
    refractmap = refractmap,
});